/*
  WebFont Demo javascript
  
  (C) 2013 High-Logic B.V.
  
  http://www.high-logic.com
*/

var haveErrors = false;
var haveOTLF   = false;

function Initialize() {
  if (fctrial) {
    AddError("Because this Web Font is created with a trial version of FontCreator, only a subset of characters is available. See the FontCreator User Manual about the limitations of exported fonts during the trial period.");
  }
  BrowserCheck(otf.length > 0, colorfont);
  ProcessErrors();
  InitializeOpenTypeFeatures();
  UpdatePreviewText(document.getElementById("input"));
}

function AddError(aError) {
  haveErrors = true;
  id = document.getElementById('errorlist');
  id.innerHTML += "<li>" + aError + "</li>";
  return false;
}

function ProcessErrors() {
  if (!haveErrors) {
    document.getElementById('errors').style.display = "none";
  }
  else {
    document.getElementById("nojserror").style.display = "none";
  }
}

function DetermineBrowser() {
  var browserstr = navigator.userAgent.toLowerCase();
  var result = Array();
  result["name"] = "unknown";
  result["fullname"] = "unknown";
  result["version"] = "unknown";
  if (match = browserstr.match("chrome/([0-9]+)")) {
    result["name"] = "chrome";
    result["fullname"] = "Google Chrome";
    result["version"] = match[1];
  }
  else if (match = browserstr.match("firefox/([0-9]+)")) {
    result["name"] = "firefox";
    result["fullname"] = "Mozilla Firefox";
    result["version"] = match[1];
  }
  else if (match = browserstr.match("opera/([0-9]+)")) {
    result["name"] = "opera";
    result["fullname"] = "Opera";
    result["version"] = match[1];
  }    
  else if (match = browserstr.match("safari/([0-9]+)")) {
    result["name"] = "safari";
    result["fullname"] = "Apple Safari";
    result["version"] = match[1];
  }
  else if (match = browserstr.match("msie ([0-9]+)")) {
    result["name"] = "ie";
    result["fullname"] = "Microsoft Internet Explorer";
    result["version"] = match[1];
  }  
  else if (match = browserstr.match("trident/([0-9]+).+; .*? rv:([0-9]+)")) {
    /* IE 11 and up */
    if (match[1] >= 7) {
      result["name"] = "ie";
      result["fullname"] = "Microsoft Internet Explorer";
      result["version"] = match[2];
    }
  }   
  return result;
}

function DetermineOS() {
  var browserstr = navigator.userAgent.toLowerCase();
  var result = Array();
  result["name"] = "unknown";
  result["version"] = "unknown";
  if (match = browserstr.match("windows.*? ([0-9\.]+);")) {
    result["name"] = "windows";
	result["version"] = match[1];
  }
  return result;
}

function BrowserCheck(aOTLF, aColor) {
 
  var browser = DetermineBrowser();
  var os = DetermineOS();
  var id = document.getElementById("errorlist");

  switch (browser["name"]) {
    case "firefox" :
      if (aOTLF) {
	    if (browser["version"] < 4) {
          return AddError("You need at least FireFox 4 or a CSS 3.0 compatible browser in order to use OpenType Features.");
        }
	  }
	  if (aColor) {
	    return AddError("Firefox does not support color fonts at least up to version 22");
	  }
    break;
    case "chrome" : 
      if (browser["version"] < 22) {
        return AddError("You need at least Chrome 22 or a CSS 3.0 compatible browserin order to use OpenType Features.");
      }
	  if (aColor) {
	    return AddError("Chrome does not support color fonts at least up to version 28");
	  }
    break;
    case "ie" : 
      if (aOTLF && (browser["version"] < 10)) {
        return AddError("You need at least Internet Explorer 10 or a CSS 3.0 compatible browser in order to use OpenType Features.");
      }
	  if (aColor) {
		if (browser["version"] < 11) {
	      return AddError("You need at least Internet Explorer 11 in order to use Color Fonts.");
		}
		else {
		  if (os["version"] < 6.3) {
		    return AddError("You need at least Windows 8.1 to use Color Fonts");
		  }
		}
	  }
    break;
    case "opera" : 
      if (browser["version"] < 15) {
        return AddError("You need at least Opera 15 or a CSS 3.0 compatible browser in order to use OpenType Features.");
      }
      else {
        return AddWarning("Warning: This version of Opera might not support OpenType features.");
      }
	  if (aColor) {
	    return AddError("Opera does not support color fonts at least up to version 16");
	  }
    break;
    default :
      return AddError("Unable to determine your browser and/or version. OpenType Features might not display correctly.");
    break;
  }
}

function UpdateFeatures() {
  var featurestring = "";
  for (i = 0; i < otf.length; i++) {
    id = document.getElementById("otf_" + otf[i][0]);
    if (i > 0) {
      featurestring += ",";
    }
    featurestring += "'" + otf[i][0] + "' " + (id.checked ? "1" : "0");
  }  
  id = document.getElementById("preview");
  // Firefox 4+
  id.style.MozFontFeatureSettings = featurestring;
  // Chrome 20+ / Safari (OSX only)
  id.style.webkitFontFeatureSettings = featurestring;
  // Official CSS 3.0
  id.style.fontFeatureSettings = featurestring;
}

function SetAllFeatures(aValue) {
  for (i = 0; i < otf.length; i++) {
    id = document.getElementById("otf_" + otf[i][0]);
    id.checked = aValue;
  }  
  UpdateFeatures();
}

function SetDefaultFeatures() {
  for (i = 0; i < otf.length; i++) {
    id = document.getElementById("otf_" + otf[i][0]);
    id.checked = otf[i][2];
  }  
  UpdateFeatures();
}

function InitializeOpenTypeFeatures() {
  id = document.getElementById("otfeatures");
  if (otf.length == 0) {
    id.innerHTML += "This font does not contain any OpenType Features.";
    return;
  
  }
  id.innerHTML += "<input type='button' value='Disable all' onclick='SetAllFeatures(false)'/> ";
  id.innerHTML += "<input type='button' value='Enable all' onclick='SetAllFeatures(true)'/> ";
  id.innerHTML += "<input type='button' value='Default' onclick='SetDefaultFeatures()'/><hr/>";
  for (i = 0; i < otf.length; i++) {
    checked = otf[i][2] ? " checked='checked'" : "";
    id.innerHTML += "<label><input id='otf_"+otf[i][0]+"'"+checked+" type='checkbox' onclick='UpdateFeatures()'> " + otf[i][0] + " - " + otf[i][1] + "</label><br/>";
  }
  UpdateFeatures();
}

function UpdatePreviewText(sender) {
  id = document.getElementById("preview");
  id.innerHTML = sender.value.replace(/\n/g, "<br/>");
}

function UpdatePreviewQuickPick(sender) {
  id = document.getElementById("input");
  switch (sender.value) {
    case "0" : 
      id.value = id.defaultValue;
    break;
    case "1" : 
      id.value = "abcdefghijklmnopqrstuvwxyz\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n1234567890";
    break;
    case "2" : 
      id.value = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed molestie augue vel quam dapibus sollicitudin. Sed vestibulum erat ac nibh varius vestibulum. Quisque a quam at est sodales pulvinar ac vel nisl. Cras sit amet consectetur dolor. Aliquam nisl lorem, iaculis eget aliquam pharetra, tincidunt id turpis. Ut sit amet nisl sed ipsum tempor luctus. Aenean vitae tristique sem. Pellentesque turpis dolor, lacinia id fermentum et, dapibus ac ipsum. Etiam nisi quam, feugiat vitae eleifend vel, luctus et mi.";
    break;
  }
  UpdatePreviewText(document.getElementById("input"));
}

function UpdateFontSize(sender) {
  id = document.getElementById("preview");
  id.style.fontSize = sender.value + "pt";
  id.style.lineHeight = sender.value + "pt";
}

function UpdateFontColor(sender) {
  id = document.getElementById("preview");
  id.style.color = "#" + sender.value;
}